/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.lua.api.keybind.FiguraKeybind;
import org.figuramc.figura.utils.FiguraText;
import org.figuramc.figura.utils.ui.UIHelper;

public class KeybindWidgetHelper {
    private Component tooltip;
    private boolean vanillaConflict;
    private boolean avatarConflict;

    public void renderConflictBars(GuiGraphics gui, int x, int y, int width, int height) {
        if (this.vanillaConflict || this.avatarConflict) {
            if (this.avatarConflict) {
                gui.fill(x, y, x + width, y + height, ChatFormatting.YELLOW.getColor() | 0xFF000000);
                x -= width + 4;
            }
            if (this.vanillaConflict) {
                gui.fill(x, y, x + width, y + height, ChatFormatting.RED.getColor() | 0xFF000000);
            }
        }
    }

    public void renderTooltip() {
        if (this.tooltip != null) {
            UIHelper.setTooltip(this.tooltip);
        }
    }

    public void setTooltip(FiguraKeybind keybind, List<FiguraKeybind> keyBindings) {
        Component vanilla;
        boolean hasAvatarConflict;
        MutableComponent text = Component.empty();
        Component avatar = this.checkForAvatarConflicts(keybind, keyBindings);
        boolean bl = hasAvatarConflict = avatar != null && !avatar.getString().isBlank();
        if (hasAvatarConflict) {
            text.append(avatar);
        }
        if ((vanilla = this.checkForVanillaConflicts(keybind)) != null && !vanilla.getString().isBlank()) {
            if (hasAvatarConflict) {
                text.append("\n");
            }
            text.append(vanilla);
        }
        this.setTooltipTail((Component)text);
    }

    public void setTooltip(KeyMapping keybind) {
        MutableComponent text = Component.empty();
        Component vanilla = this.checkForVanillaConflicts(keybind);
        if (vanilla != null && !vanilla.getString().isBlank()) {
            text.append(vanilla);
        }
        this.setTooltipTail((Component)text);
    }

    private void setTooltipTail(Component text) {
        this.tooltip = this.vanillaConflict || this.avatarConflict ? FiguraText.of("gui.duplicate_keybind", text) : null;
    }

    public Component getText(boolean isDefault, boolean isSelected, Component initialMessage) {
        MutableComponent message = initialMessage.copy();
        if (isDefault || isSelected) {
            message.withStyle(ChatFormatting.WHITE);
        } else {
            message.withStyle(FiguraMod.getAccentColor());
        }
        if (isSelected) {
            message.withStyle(ChatFormatting.UNDERLINE);
        }
        if (this.avatarConflict || this.vanillaConflict) {
            MutableComponent left = Component.literal((String)"[ ").withStyle(this.vanillaConflict ? ChatFormatting.RED : ChatFormatting.YELLOW);
            MutableComponent right = Component.literal((String)" ]").withStyle(this.avatarConflict ? ChatFormatting.YELLOW : ChatFormatting.RED);
            message = left.append((Component)message).append((Component)right);
        }
        if (isSelected) {
            message = Component.literal((String)"> ").append((Component)message).append(" <").withStyle(FiguraMod.getAccentColor());
        }
        return message;
    }

    public Component checkForAvatarConflicts(FiguraKeybind keybind, List<FiguraKeybind> keyBindings) {
        this.avatarConflict = false;
        int id = keybind.getID();
        if (id == -1) {
            return null;
        }
        MutableComponent message = Component.empty();
        for (FiguraKeybind keyBinding : keyBindings) {
            if (keyBinding == keybind || keyBinding.getID() != id) continue;
            this.avatarConflict = true;
            message.append((Component)Component.literal((String)"\n\u2022 ").withStyle(ChatFormatting.YELLOW).append(keyBinding.getName()));
        }
        return message;
    }

    public Component checkForVanillaConflicts(FiguraKeybind keybind) {
        this.vanillaConflict = false;
        if (keybind.getID() == -1) {
            return null;
        }
        String keyName = keybind.getKey();
        MutableComponent message = Component.empty();
        for (KeyMapping key : Minecraft.getInstance().options.keyMappings) {
            if (!key.saveString().equals(keyName)) continue;
            this.vanillaConflict = true;
            message.append((Component)Component.literal((String)"\n\u2022 ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)key.getCategory())).append(": ").append((Component)Component.translatable((String)key.getName())));
        }
        return message;
    }

    public Component checkForVanillaConflicts(KeyMapping keybind) {
        this.vanillaConflict = false;
        if (keybind.isUnbound()) {
            return null;
        }
        String keyName = keybind.saveString();
        MutableComponent message = Component.empty();
        for (KeyMapping key : Minecraft.getInstance().options.keyMappings) {
            if (key == keybind || !key.saveString().equals(keyName)) continue;
            this.vanillaConflict = true;
            message.append((Component)Component.literal((String)"\n\u2022 ").withStyle(ChatFormatting.RED).append((Component)Component.translatable((String)key.getCategory())).append(": ").append((Component)Component.translatable((String)key.getName())));
        }
        return message;
    }
}

